'use strict';

var _compileCache = require('./compile-cache');

var _compileCache2 = _interopRequireDefault(_compileCache);

var _compilerHost = require('./compiler-host');

var _compilerHost2 = _interopRequireDefault(_compilerHost);

var _configParser = require('./config-parser');

var configParser = _interopRequireWildcard(_configParser);

var _fileChangeCache = require('./file-change-cache');

var _fileChangeCache2 = _interopRequireDefault(_fileChangeCache);

var _protocolHook = require('./protocol-hook');

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// NB: Patch a bug in Electron that affects electron-prebuilt-compile that
// we can't fix any other way. Yes it _does_ feelbadman.jpg
const fs = require('fs');
fs.statSyncNoException = fs.statSyncNoException || function () {
  try {
    return fs.statSync(...arguments);
  } catch (e) {
    return null;
  }
};

let enableLiveReload = null;
let watchPath = null;

module.exports = Object.assign({
  // NB: delay-load live-reload so we don't load RxJS in production
  enableLiveReload: function () {
    enableLiveReload = enableLiveReload || require('./live-reload').enableLiveReload;
    return enableLiveReload(...arguments);
  },
  watchPath: function () {
    watchPath = watchPath || require('./pathwatcher-rx').watchPath;
    return watchPath(...arguments);
  }
}, configParser, { CompilerHost: _compilerHost2.default, FileChangedCache: _fileChangeCache2.default, CompileCache: _compileCache2.default, addBypassChecker: _protocolHook.addBypassChecker });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9pbmRleC5qcyJdLCJuYW1lcyI6WyJjb25maWdQYXJzZXIiLCJmcyIsInJlcXVpcmUiLCJzdGF0U3luY05vRXhjZXB0aW9uIiwic3RhdFN5bmMiLCJlIiwiZW5hYmxlTGl2ZVJlbG9hZCIsIndhdGNoUGF0aCIsIm1vZHVsZSIsImV4cG9ydHMiLCJPYmplY3QiLCJhc3NpZ24iLCJDb21waWxlckhvc3QiLCJGaWxlQ2hhbmdlZENhY2hlIiwiQ29tcGlsZUNhY2hlIiwiYWRkQnlwYXNzQ2hlY2tlciJdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7OztBQUNBOzs7O0FBQ0E7O0lBQVlBLFk7O0FBQ1o7Ozs7QUFDQTs7Ozs7O0FBRUE7QUFDQTtBQUNBLE1BQU1DLEtBQUtDLFFBQVEsSUFBUixDQUFYO0FBQ0FELEdBQUdFLG1CQUFILEdBQXlCRixHQUFHRSxtQkFBSCxJQUEyQixZQUFhO0FBQy9ELE1BQUk7QUFDRixXQUFPRixHQUFHRyxRQUFILENBQVksWUFBWixDQUFQO0FBQ0QsR0FGRCxDQUVFLE9BQU9DLENBQVAsRUFBVTtBQUNWLFdBQU8sSUFBUDtBQUNEO0FBQ0YsQ0FORDs7QUFRQSxJQUFJQyxtQkFBbUIsSUFBdkI7QUFDQSxJQUFJQyxZQUFZLElBQWhCOztBQUVBQyxPQUFPQyxPQUFQLEdBQWlCQyxPQUFPQyxNQUFQLENBQWM7QUFDN0I7QUFDQUwsb0JBQWtCLFlBQWtCO0FBQ2xDQSx1QkFBbUJBLG9CQUFvQkosUUFBUSxlQUFSLEVBQXlCSSxnQkFBaEU7QUFDQSxXQUFPQSxpQkFBaUIsWUFBakIsQ0FBUDtBQUNELEdBTDRCO0FBTTdCQyxhQUFXLFlBQWtCO0FBQzNCQSxnQkFBWUEsYUFBYUwsUUFBUSxrQkFBUixFQUE0QkssU0FBckQ7QUFDQSxXQUFPQSxVQUFVLFlBQVYsQ0FBUDtBQUNEO0FBVDRCLENBQWQsRUFXZlAsWUFYZSxFQVlmLEVBQUVZLG9DQUFGLEVBQWdCQywyQ0FBaEIsRUFBa0NDLG9DQUFsQyxFQUFnREMsZ0RBQWhELEVBWmUsQ0FBakIiLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgQ29tcGlsZUNhY2hlIGZyb20gJy4vY29tcGlsZS1jYWNoZSc7XG5pbXBvcnQgQ29tcGlsZXJIb3N0IGZyb20gJy4vY29tcGlsZXItaG9zdCc7XG5pbXBvcnQgKiBhcyBjb25maWdQYXJzZXIgZnJvbSAnLi9jb25maWctcGFyc2VyJztcbmltcG9ydCBGaWxlQ2hhbmdlZENhY2hlIGZyb20gJy4vZmlsZS1jaGFuZ2UtY2FjaGUnO1xuaW1wb3J0IHthZGRCeXBhc3NDaGVja2VyfSBmcm9tICcuL3Byb3RvY29sLWhvb2snO1xuXG4vLyBOQjogUGF0Y2ggYSBidWcgaW4gRWxlY3Ryb24gdGhhdCBhZmZlY3RzIGVsZWN0cm9uLXByZWJ1aWx0LWNvbXBpbGUgdGhhdFxuLy8gd2UgY2FuJ3QgZml4IGFueSBvdGhlciB3YXkuIFllcyBpdCBfZG9lc18gZmVlbGJhZG1hbi5qcGdcbmNvbnN0IGZzID0gcmVxdWlyZSgnZnMnKTtcbmZzLnN0YXRTeW5jTm9FeGNlcHRpb24gPSBmcy5zdGF0U3luY05vRXhjZXB0aW9uIHx8ICgoLi4uYXJncykgPT4ge1xuICB0cnkge1xuICAgIHJldHVybiBmcy5zdGF0U3luYyguLi5hcmdzKTtcbiAgfSBjYXRjaCAoZSkge1xuICAgIHJldHVybiBudWxsO1xuICB9XG59KTtcblxubGV0IGVuYWJsZUxpdmVSZWxvYWQgPSBudWxsO1xubGV0IHdhdGNoUGF0aCA9IG51bGw7XG5cbm1vZHVsZS5leHBvcnRzID0gT2JqZWN0LmFzc2lnbih7XG4gIC8vIE5COiBkZWxheS1sb2FkIGxpdmUtcmVsb2FkIHNvIHdlIGRvbid0IGxvYWQgUnhKUyBpbiBwcm9kdWN0aW9uXG4gIGVuYWJsZUxpdmVSZWxvYWQ6IGZ1bmN0aW9uKC4uLmFyZ3MpIHtcbiAgICBlbmFibGVMaXZlUmVsb2FkID0gZW5hYmxlTGl2ZVJlbG9hZCB8fCByZXF1aXJlKCcuL2xpdmUtcmVsb2FkJykuZW5hYmxlTGl2ZVJlbG9hZDtcbiAgICByZXR1cm4gZW5hYmxlTGl2ZVJlbG9hZCguLi5hcmdzKTtcbiAgfSxcbiAgd2F0Y2hQYXRoOiBmdW5jdGlvbiguLi5hcmdzKSB7XG4gICAgd2F0Y2hQYXRoID0gd2F0Y2hQYXRoIHx8IHJlcXVpcmUoJy4vcGF0aHdhdGNoZXItcngnKS53YXRjaFBhdGg7XG4gICAgcmV0dXJuIHdhdGNoUGF0aCguLi5hcmdzKTtcbiAgfSxcbn0sXG4gIGNvbmZpZ1BhcnNlcixcbiAgeyBDb21waWxlckhvc3QsIEZpbGVDaGFuZ2VkQ2FjaGUsIENvbXBpbGVDYWNoZSwgYWRkQnlwYXNzQ2hlY2tlciB9XG4pO1xuIl19